//==============================================================================
//
// Title:		XTDR_2XX.h
// Release:		2.6.0 (06/09/16)
// Purpose:		XTDR driver module and DLL functionality (v2.x.x)
//
// Copyright:	(c) 2016, HYPERLABS INC. All rights reserved.
//
//==============================================================================

#ifndef __XTDR_2XX_H__
#define __XTDR_2XX_H__

#ifdef __cplusplus
extern "C" {
#endif


//==============================================================================
// Include files

#include "FTD2XX.h"


//==============================================================================
// Types

	union dly_fract
	{
		int val16;

		struct
		{
			char l_byte;
			char u_byte;
		} b_data;
	};

	typedef union dly_fract DLY16;

	union dly_type
	{
		struct
		{
			int interp_value;
			int cntr_value;
		} s_data;

		struct
		{
			char interp_lsb;
			char interp_msb;
			char cntr_lsb;
			char cntr_msb;
		} b_data;

		long l_data;
	};

	typedef union dly_type DLY32;


//==============================================================================
// Global functions

// User-facing functions
	int 	__stdcall	xtdr_acquire (int acqNum);
	int 	__stdcall	xtdr_cal (int stim, int sampl, int getEdge);
	int 	__stdcall	xtdr_diff (int acqNum); 	  
	int 	__stdcall	xtdr_dump (char *filename);
	int 	__stdcall	xtdr_environ (int x, int y, double start, double end, double k);
	double	__stdcall	xtdr_getX (int idx);
	double	__stdcall	xtdr_getY (int idx);
	int 	__stdcall	xtdr_init (void);
	int 	__stdcall	xtdr_zero (double x, int isDiff);

// Other driver functions
	int 	__stdcall	xtdr_chan (int stim, int sampl);
	INT32 	__stdcall	getOffset (void);
	int 	__stdcall	initDevice (int tb);
	int 	__stdcall	readData (long increment, long start_delay, INT32 offset, int forceAbs);
	int 	__stdcall	readRaw (INT32 rec_len, INT32 increment, INT32 start_val);
	double 	__stdcall	meanArray (void);
	void 	__stdcall	sendChannelSetup (unsigned char stimulus, unsigned char sampler);

// FTDI functionality
	char 	__stdcall	ftrdbyte (void);
	void 	__stdcall	ftwrbyte (char ch);
	int 	__stdcall	usbftdi_close (void);
	int 	__stdcall	usbftdi_open (void);


#ifdef __cplusplus
}
#endif

#endif  /* ndef __XTDR_2XX_H__ */
